Write-Host "Configuring to configure displays on startup using Task Scheduler"

$taskName = "ConfigureDisplays"
$taskDescription = "Configure displays on RadSight user login"
$cmdPath = "c:\Tools\run-hidden64.exe"
$powershellPath = "$env:SystemRoot\system32\WindowsPowerShell\v1.0\powershell.exe"
$commandToLaunch = "c:\Tools\Configure-Displays.ps1"

# Use run-hidden to start powershell so that it doesn't flash on the screen
$action = New-ScheduledTaskAction -Execute $cmdPath -Argument "`"$powerShellPath`" -NoProfile -NonInteractive -WindowStyle Hidden -Command `"$commandToLaunch`""
$trigger = New-ScheduledTaskTrigger -AtLogOn -User "RadSight"
$principal = New-ScheduledTaskPrincipal -UserId "RadSight" -LogonType Interactive -RunLevel Highest
$settings = New-ScheduledTaskSettingsSet -AllowStartIfOnBatteries -DontStopIfGoingOnBatteries -Hidden

Register-ScheduledTask -TaskName $taskName -Description $taskDescription -Action $action -Trigger $trigger -Principal $principal -Settings $settings -Force

# SIG # Begin signature block
# MII+GwYJKoZIhvcNAQcCoII+DDCCPggCAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCAopx923gtUAgOV
# lX5sdncpnRDKIx/oJsVElLyhUu1xzKCCIuAwggXMMIIDtKADAgECAhBUmNLR1FsZ
# lUgTecgRwIeZMA0GCSqGSIb3DQEBDAUAMHcxCzAJBgNVBAYTAlVTMR4wHAYDVQQK
# ExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xSDBGBgNVBAMTP01pY3Jvc29mdCBJZGVu
# dGl0eSBWZXJpZmljYXRpb24gUm9vdCBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkgMjAy
# MDAeFw0yMDA0MTYxODM2MTZaFw00NTA0MTYxODQ0NDBaMHcxCzAJBgNVBAYTAlVT
# MR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xSDBGBgNVBAMTP01pY3Jv
# c29mdCBJZGVudGl0eSBWZXJpZmljYXRpb24gUm9vdCBDZXJ0aWZpY2F0ZSBBdXRo
# b3JpdHkgMjAyMDCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBALORKgeD
# Bmf9np3gx8C3pOZCBH8Ppttf+9Va10Wg+3cL8IDzpm1aTXlT2KCGhFdFIMeiVPvH
# or+Kx24186IVxC9O40qFlkkN/76Z2BT2vCcH7kKbK/ULkgbk/WkTZaiRcvKYhOuD
# PQ7k13ESSCHLDe32R0m3m/nJxxe2hE//uKya13NnSYXjhr03QNAlhtTetcJtYmrV
# qXi8LW9J+eVsFBT9FMfTZRY33stuvF4pjf1imxUs1gXmuYkyM6Nix9fWUmcIxC70
# ViueC4fM7Ke0pqrrBc0ZV6U6CwQnHJFnni1iLS8evtrAIMsEGcoz+4m+mOJyoHI1
# vnnhnINv5G0Xb5DzPQCGdTiO0OBJmrvb0/gwytVXiGhNctO/bX9x2P29Da6SZEi3
# W295JrXNm5UhhNHvDzI9e1eM80UHTHzgXhgONXaLbZ7LNnSrBfjgc10yVpRnlyUK
# xjU9lJfnwUSLgP3B+PR0GeUw9gb7IVc+BhyLaxWGJ0l7gpPKWeh1R+g/OPTHU3mg
# trTiXFHvvV84wRPmeAyVWi7FQFkozA8kwOy6CXcjmTimthzax7ogttc32H83rwjj
# O3HbbnMbfZlysOSGM1l0tRYAe1BtxoYT2v3EOYI9JACaYNq6lMAFUSw0rFCZE4e7
# swWAsk0wAly4JoNdtGNz764jlU9gKL431VulAgMBAAGjVDBSMA4GA1UdDwEB/wQE
# AwIBhjAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBTIftJqhSobyhmYBAcnz1AQ
# T2ioojAQBgkrBgEEAYI3FQEEAwIBADANBgkqhkiG9w0BAQwFAAOCAgEAr2rd5hnn
# LZRDGU7L6VCVZKUDkQKL4jaAOxWiUsIWGbZqWl10QzD0m/9gdAmxIR6QFm3FJI9c
# Zohj9E/MffISTEAQiwGf2qnIrvKVG8+dBetJPnSgaFvlVixlHIJ+U9pW2UYXeZJF
# xBA2CFIpF8svpvJ+1Gkkih6PsHMNzBxKq7Kq7aeRYwFkIqgyuH4yKLNncy2RtNwx
# AQv3Rwqm8ddK7VZgxCwIo3tAsLx0J1KH1r6I3TeKiW5niB31yV2g/rarOoDXGpc8
# FzYiQR6sTdWD5jw4vU8w6VSp07YEwzJ2YbuwGMUrGLPAgNW3lbBeUU0i/OxYqujY
# lLSlLu2S3ucYfCFX3VVj979tzR/SpncocMfiWzpbCNJbTsgAlrPhgzavhgplXHT2
# 6ux6anSg8Evu75SjrFDyh+3XOjCDyft9V77l4/hByuVkrrOj7FjshZrM77nq81YY
# uVxzmq/FdxeDWds3GhhyVKVB0rYjdaNDmuV3fJZ5t0GNv+zcgKCf0Xd1WF81E+Al
# GmcLfc4l+gcK5GEh2NQc5QfGNpn0ltDGFf5Ozdeui53bFv0ExpK91IjmqaOqu/dk
# ODtfzAzQNb50GQOmxapMomE2gj4d8yu8l13bS3g7LfU772Aj6PXsCyM2la+YZr9T
# 03u4aUoqlmZpxJTG9F9urJh4iIAGXKKy7aIwggcEMIIE7KADAgECAhMzAAYaeTMd
# 9e5ebamiAAAABhp5MA0GCSqGSIb3DQEBDAUAMFoxCzAJBgNVBAYTAlVTMR4wHAYD
# VQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xKzApBgNVBAMTIk1pY3Jvc29mdCBJ
# RCBWZXJpZmllZCBDUyBBT0MgQ0EgMDIwHhcNMjUxMTExMjAzMzAyWhcNMjUxMTE0
# MjAzMzAyWjCBgDELMAkGA1UEBhMCR0IxDzANBgNVBAgTBkRvcnNldDEOMAwGA1UE
# BxMFUG9vbGUxJzAlBgNVBAoTHkNoYXJ0aG91c2UgRGF0YSBNYW5hZ2VtZW50IEx0
# ZDEnMCUGA1UEAxMeQ2hhcnRob3VzZSBEYXRhIE1hbmFnZW1lbnQgTHRkMIIBojAN
# BgkqhkiG9w0BAQEFAAOCAY8AMIIBigKCAYEAmcc32FHGLV4FiKzse5eN9PjhviRa
# CblNvBtnqrPnUAYYuJnfTT+uo4/IDSXK6e9cz2ayR0wdaIJSElN50pHTPrWMDQSL
# P7wkC1LovyoEhNzVb40CoJhCTXQTkHqnACMD9NqeDdyaF4r0Nb0u716+W67pv/CA
# CE8Lpi9bRQQT1aUJJlRG57wzPESwkDyZVrqE61MYKeWlQWErF2VSZJaA8X9pJuvH
# 1WxVB+Mr7LIehjb9cxmUfelY1LkKimcVkdpSlZsBCZVANliqCugFrqMLJ1jQRmpd
# 8xgaGT3GwW5Q4iQrKyn4Dw2lDVncgTMp/hoyNIQzYfUw44hS0zfo8ZXOUjptAqN8
# vmAE5ugAdxwmAts0TtK6RwS7xrAm1dgXTHt5262ALFRyo3/NShidyL3k8a4hSFwD
# tWFHtXJv7HKGxbCCZdR8TGMFupw4IeWSBdApLGInTzSMhDxAyTK26McpCGRe3c1z
# BOw753ZIhx5k0LhWztmdCXWZIh9h1UBySzdDAgMBAAGjggIaMIICFjAMBgNVHRMB
# Af8EAjAAMA4GA1UdDwEB/wQEAwIHgDA9BgNVHSUENjA0BgorBgEEAYI3YQEABggr
# BgEFBQcDAwYcKwYBBAGCN2GDq+jHTIHw4u1igoD5nDWBpKyqVzAdBgNVHQ4EFgQU
# uRPRKwj4iXWQUhjHlE/YCMqM9e8wHwYDVR0jBBgwFoAUJEWZoXeQKnzDyoOwbmQW
# hCr4LGcwZwYDVR0fBGAwXjBcoFqgWIZWaHR0cDovL3d3dy5taWNyb3NvZnQuY29t
# L3BraW9wcy9jcmwvTWljcm9zb2Z0JTIwSUQlMjBWZXJpZmllZCUyMENTJTIwQU9D
# JTIwQ0ElMjAwMi5jcmwwgaUGCCsGAQUFBwEBBIGYMIGVMGQGCCsGAQUFBzAChlho
# dHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NlcnRzL01pY3Jvc29mdCUy
# MElEJTIwVmVyaWZpZWQlMjBDUyUyMEFPQyUyMENBJTIwMDIuY3J0MC0GCCsGAQUF
# BzABhiFodHRwOi8vb25lb2NzcC5taWNyb3NvZnQuY29tL29jc3AwZgYDVR0gBF8w
# XTBRBgwrBgEEAYI3TIN9AQEwQTA/BggrBgEFBQcCARYzaHR0cDovL3d3dy5taWNy
# b3NvZnQuY29tL3BraW9wcy9Eb2NzL1JlcG9zaXRvcnkuaHRtMAgGBmeBDAEEATAN
# BgkqhkiG9w0BAQwFAAOCAgEAkYGvQxKMPRNLuXymFInLM6+tzuw0G5i8qcvMna7j
# ltVc7EtRsV4KoOBZNJ9auRAvdhFrqVYcn19Kvk5bdbRQW50EmDEdH5ybIuE1v5VP
# OjGAg9xvXFk1RdISpST9ghRE+JpdI2gx1uKGUGFCjll6nU/WuFpskg2jV6HQVg7t
# cdvIDy3hgyZtsnDhmAVL5+qB6vyX/OBGDrfJJwLty0ageLObO88+fJdES7ZYsmC1
# Gn9Vou6rJYRvawWw/H5nIeRcXXwRes9yQ+UTijQVYml/vi4oOLROYVk9Auf31WB5
# qyasiq/VGV8U6QQR/8auaen0Wn1VUm9U++cDFVsMH6hvGXrByof7kuE6BQbYk2T0
# 8MaNus4xleApIAYyWr8Prtwe71+T2S+OM/NE+T0JwATBrSwUjBftUzM9nQ3iHGJW
# gT0+1Yh0b/eKcGRbTt9q3M79WJFkvrcbQmqMUhG8Xgrfykf6Bp6AvCN5T03yiVq1
# Xjau+kf/EJeYzrhw1H5++1xVbSL1a+BudVAQ4HhrKAE5wR6Ca37NFq4tTI4BGR5o
# ERoxq92UpXtQYMo8AOC0TqmdFsqrAmmqi+7Hh1sQhS3IpSS9BBlqfRUUZdPs/ATJ
# wyGaI2eSqCeROzqTE/BUP6ICU26FD03Mr1QnmMVAN3ligIAAAHHTMJmNaLHVuhVU
# DCAwggcEMIIE7KADAgECAhMzAAYaeTMd9e5ebamiAAAABhp5MA0GCSqGSIb3DQEB
# DAUAMFoxCzAJBgNVBAYTAlVTMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
# b24xKzApBgNVBAMTIk1pY3Jvc29mdCBJRCBWZXJpZmllZCBDUyBBT0MgQ0EgMDIw
# HhcNMjUxMTExMjAzMzAyWhcNMjUxMTE0MjAzMzAyWjCBgDELMAkGA1UEBhMCR0Ix
# DzANBgNVBAgTBkRvcnNldDEOMAwGA1UEBxMFUG9vbGUxJzAlBgNVBAoTHkNoYXJ0
# aG91c2UgRGF0YSBNYW5hZ2VtZW50IEx0ZDEnMCUGA1UEAxMeQ2hhcnRob3VzZSBE
# YXRhIE1hbmFnZW1lbnQgTHRkMIIBojANBgkqhkiG9w0BAQEFAAOCAY8AMIIBigKC
# AYEAmcc32FHGLV4FiKzse5eN9PjhviRaCblNvBtnqrPnUAYYuJnfTT+uo4/IDSXK
# 6e9cz2ayR0wdaIJSElN50pHTPrWMDQSLP7wkC1LovyoEhNzVb40CoJhCTXQTkHqn
# ACMD9NqeDdyaF4r0Nb0u716+W67pv/CACE8Lpi9bRQQT1aUJJlRG57wzPESwkDyZ
# VrqE61MYKeWlQWErF2VSZJaA8X9pJuvH1WxVB+Mr7LIehjb9cxmUfelY1LkKimcV
# kdpSlZsBCZVANliqCugFrqMLJ1jQRmpd8xgaGT3GwW5Q4iQrKyn4Dw2lDVncgTMp
# /hoyNIQzYfUw44hS0zfo8ZXOUjptAqN8vmAE5ugAdxwmAts0TtK6RwS7xrAm1dgX
# THt5262ALFRyo3/NShidyL3k8a4hSFwDtWFHtXJv7HKGxbCCZdR8TGMFupw4IeWS
# BdApLGInTzSMhDxAyTK26McpCGRe3c1zBOw753ZIhx5k0LhWztmdCXWZIh9h1UBy
# SzdDAgMBAAGjggIaMIICFjAMBgNVHRMBAf8EAjAAMA4GA1UdDwEB/wQEAwIHgDA9
# BgNVHSUENjA0BgorBgEEAYI3YQEABggrBgEFBQcDAwYcKwYBBAGCN2GDq+jHTIHw
# 4u1igoD5nDWBpKyqVzAdBgNVHQ4EFgQUuRPRKwj4iXWQUhjHlE/YCMqM9e8wHwYD
# VR0jBBgwFoAUJEWZoXeQKnzDyoOwbmQWhCr4LGcwZwYDVR0fBGAwXjBcoFqgWIZW
# aHR0cDovL3d3dy5taWNyb3NvZnQuY29tL3BraW9wcy9jcmwvTWljcm9zb2Z0JTIw
# SUQlMjBWZXJpZmllZCUyMENTJTIwQU9DJTIwQ0ElMjAwMi5jcmwwgaUGCCsGAQUF
# BwEBBIGYMIGVMGQGCCsGAQUFBzAChlhodHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20v
# cGtpb3BzL2NlcnRzL01pY3Jvc29mdCUyMElEJTIwVmVyaWZpZWQlMjBDUyUyMEFP
# QyUyMENBJTIwMDIuY3J0MC0GCCsGAQUFBzABhiFodHRwOi8vb25lb2NzcC5taWNy
# b3NvZnQuY29tL29jc3AwZgYDVR0gBF8wXTBRBgwrBgEEAYI3TIN9AQEwQTA/Bggr
# BgEFBQcCARYzaHR0cDovL3d3dy5taWNyb3NvZnQuY29tL3BraW9wcy9Eb2NzL1Jl
# cG9zaXRvcnkuaHRtMAgGBmeBDAEEATANBgkqhkiG9w0BAQwFAAOCAgEAkYGvQxKM
# PRNLuXymFInLM6+tzuw0G5i8qcvMna7jltVc7EtRsV4KoOBZNJ9auRAvdhFrqVYc
# n19Kvk5bdbRQW50EmDEdH5ybIuE1v5VPOjGAg9xvXFk1RdISpST9ghRE+JpdI2gx
# 1uKGUGFCjll6nU/WuFpskg2jV6HQVg7tcdvIDy3hgyZtsnDhmAVL5+qB6vyX/OBG
# DrfJJwLty0ageLObO88+fJdES7ZYsmC1Gn9Vou6rJYRvawWw/H5nIeRcXXwRes9y
# Q+UTijQVYml/vi4oOLROYVk9Auf31WB5qyasiq/VGV8U6QQR/8auaen0Wn1VUm9U
# ++cDFVsMH6hvGXrByof7kuE6BQbYk2T08MaNus4xleApIAYyWr8Prtwe71+T2S+O
# M/NE+T0JwATBrSwUjBftUzM9nQ3iHGJWgT0+1Yh0b/eKcGRbTt9q3M79WJFkvrcb
# QmqMUhG8Xgrfykf6Bp6AvCN5T03yiVq1Xjau+kf/EJeYzrhw1H5++1xVbSL1a+Bu
# dVAQ4HhrKAE5wR6Ca37NFq4tTI4BGR5oERoxq92UpXtQYMo8AOC0TqmdFsqrAmmq
# i+7Hh1sQhS3IpSS9BBlqfRUUZdPs/ATJwyGaI2eSqCeROzqTE/BUP6ICU26FD03M
# r1QnmMVAN3ligIAAAHHTMJmNaLHVuhVUDCAwggdaMIIFQqADAgECAhMzAAAABJZQ
# S9Lb7suIAAAAAAAEMA0GCSqGSIb3DQEBDAUAMGMxCzAJBgNVBAYTAlVTMR4wHAYD
# VQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xNDAyBgNVBAMTK01pY3Jvc29mdCBJ
# RCBWZXJpZmllZCBDb2RlIFNpZ25pbmcgUENBIDIwMjEwHhcNMjEwNDEzMTczMTUy
# WhcNMjYwNDEzMTczMTUyWjBaMQswCQYDVQQGEwJVUzEeMBwGA1UEChMVTWljcm9z
# b2Z0IENvcnBvcmF0aW9uMSswKQYDVQQDEyJNaWNyb3NvZnQgSUQgVmVyaWZpZWQg
# Q1MgQU9DIENBIDAyMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA4c6g
# 6DOiY6bAOwCPbBlQF2tjo3ckUZuab5ZorMnRp4rOmwZDiTbIpzFkZ/k8k4ivBJV1
# w5/b/oykI+eXAqaaxMdyAO0ModnEW7InfQ+rTkykEzHxRbCNg6KDsTnYc/YdL7II
# iJli8k51upaHLL7CYm9YNc0SFYvlaFj2O0HjO9y/NRmcWNjamZOlRjxW2cWgUsUd
# azSHgRCek87V2bM/17b+o8WXUW91IpggRasmiZ65WEFHXKbyhm2LbhBK6ZWmQoFe
# E+GWrKWCGK/q/4RiTaMNhHXWvWv+//I58UtOxVi3DaK1fQ6YLyIIGHzD4CmtcrGi
# vxupq/crrHunGNB7//Qmul2ZP9HcOmY/aptgUnwT+20g/A37iDfuuVw6yS2Lo0/k
# p/jb+J8vE4FMqIiwxGByL482PMVBC3qd/NbFQa8Mmj6ensU+HEqv9ar+AbcKwumb
# ZqJJKmQrGaSNdWfk2NodgcWOmq7jyhbxwZOjnLj0/bwnsUNcNAe09v+qiozyQQes
# 8A3UXPcRQb8G+c0yaO2ICifWTK7ySuyUJ88k1mtN22CNftbjitiAeafoZ9Vmhn5R
# fb+S/K5arVvTcLukt5PdTDQxl557EIE6A+6XFBpdsjOzkLzdEh7ELk8PVPMjQfPC
# gKtJ84c17fd2C9+pxF1lEQUFXY/YtCL+Nms9cWUCAwEAAaOCAg4wggIKMA4GA1Ud
# DwEB/wQEAwIBhjAQBgkrBgEEAYI3FQEEAwIBADAdBgNVHQ4EFgQUJEWZoXeQKnzD
# yoOwbmQWhCr4LGcwVAYDVR0gBE0wSzBJBgRVHSAAMEEwPwYIKwYBBQUHAgEWM2h0
# dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9wa2lvcHMvRG9jcy9SZXBvc2l0b3J5Lmh0
# bTAZBgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTASBgNVHRMBAf8ECDAGAQH/AgEA
# MB8GA1UdIwQYMBaAFNlBKbAPD2Ns72nX9c0pnqRIajDmMHAGA1UdHwRpMGcwZaBj
# oGGGX2h0dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9wa2lvcHMvY3JsL01pY3Jvc29m
# dCUyMElEJTIwVmVyaWZpZWQlMjBDb2RlJTIwU2lnbmluZyUyMFBDQSUyMDIwMjEu
# Y3JsMIGuBggrBgEFBQcBAQSBoTCBnjBtBggrBgEFBQcwAoZhaHR0cDovL3d3dy5t
# aWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9NaWNyb3NvZnQlMjBJRCUyMFZlcmlm
# aWVkJTIwQ29kZSUyMFNpZ25pbmclMjBQQ0ElMjAyMDIxLmNydDAtBggrBgEFBQcw
# AYYhaHR0cDovL29uZW9jc3AubWljcm9zb2Z0LmNvbS9vY3NwMA0GCSqGSIb3DQEB
# DAUAA4ICAQBnLThdlbMNIokdKtzSa8io+pEO95Cc3VOyY/hQsIIcdMyk2hJOzLt/
# M1WXfQyElDk/QtyLzX63TdOb5J+nO8t0pzzwi7ZYvMiNqKvAQO50sMOJn3T3hCPp
# pxNNhoGFVxz2UyiQ4b2vOrcsLK9TOEFXWbUMJObR9PM0wZsABIhu4k6VVLxEDe0G
# SeQX/ZE7PHfTg44Luft4IKqYmnv1Cuosp3glFYsVegLnMWZUZ8UtO9F8QCiAouJY
# hL5OlCksgDb9ve/HQhLFnelfg6dQubIFsqB9IlConYKJZ/HaMZvYtA7y9EORK4cx
# lvTetCXAHayiSXH0ueE/T92wVG0csv5VdUyj6yVrm22vlKYAkXINKvDOB8+s4h+T
# gShlUa2ACu2FWn7JzlTSbpk0IE8REuYmkuyE/BTkk93WDMx7PwLnn4J+5fkvbjjQ
# 08OewfpMhh8SuPdQKqmZ40I4W2UyJKMMTbet16JFimSqDChgnCB6lwlpe0gfbo97
# U7prpbfBKp6B2k2f7Y+TjWrQYN+OdcPOyQAdxGGPBwJSaJG3ohdklCxgAJ5anCxe
# Yl7SjQ5Eua6atjIeVhN0KfPLFPpYz5CQU+JC2H79x4d/O6YOFR9aYe54/CGup7dR
# UIfLSv1/j0DPc6Elf3YyWxloWj8yeY3kHrZFaAlRMwhAXyPQ3rEX9zCCB54wggWG
# oAMCAQICEzMAAAAHh6M0o3uljhwAAAAAAAcwDQYJKoZIhvcNAQEMBQAwdzELMAkG
# A1UEBhMCVVMxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjFIMEYGA1UE
# AxM/TWljcm9zb2Z0IElkZW50aXR5IFZlcmlmaWNhdGlvbiBSb290IENlcnRpZmlj
# YXRlIEF1dGhvcml0eSAyMDIwMB4XDTIxMDQwMTIwMDUyMFoXDTM2MDQwMTIwMTUy
# MFowYzELMAkGA1UEBhMCVVMxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlv
# bjE0MDIGA1UEAxMrTWljcm9zb2Z0IElEIFZlcmlmaWVkIENvZGUgU2lnbmluZyBQ
# Q0EgMjAyMTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBALLwwK8ZiCji
# 3VR6TElsaQhVCbRS/3pK+MHrJSj3Zxd3KU3rlfL3qrZilYKJNqztA9OQacr1AwoN
# cHbKBLbsQAhBnIB34zxf52bDpIO3NJlfIaTE/xrweLoQ71lzCHkD7A4As1Bs076I
# u+mA6cQzsYYH/Cbl1icwQ6C65rU4V9NQhNUwgrx9rGQ//h890Q8JdjLLw0nV+ayQ
# 2Fbkd242o9kH82RZsH3HEyqjAB5a8+Ae2nPIPc8sZU6ZE7iRrRZywRmrKDp5+Tcm
# JX9MRff241UaOBs4NmHOyke8oU1TYrkxh+YeHgfWo5tTgkoSMoayqoDpHOLJs+qG
# 8Tvh8SnifW2Jj3+ii11TS8/FGngEaNAWrbyfNrC69oKpRQXY9bGH6jn9NEJv9weF
# xhTwyvx9OJLXmRGbAUXN1U9nf4lXezky6Uh/cgjkVd6CGUAf0K+Jw+GE/5VpIVbc
# Nr9rNE50Sbmy/4RTCEGvOq3GhjITbCa4crCzTTHgYYjHs1NbOc6brH+eKpWLtr+b
# Gecy9CrwQyx7S/BfYJ+ozst7+yZtG2wR461uckFu0t+gCwLdN0A6cFtSRtR8bvxV
# FyWwTtgMMFRuBa3vmUOTnfKLsLefRaQcVTgRnzeLzdpt32cdYKp+dhr2ogc+qM6K
# 4CBI5/j4VFyC4QFeUP2YAidLtvpXRRo3AgMBAAGjggI1MIICMTAOBgNVHQ8BAf8E
# BAMCAYYwEAYJKwYBBAGCNxUBBAMCAQAwHQYDVR0OBBYEFNlBKbAPD2Ns72nX9c0p
# nqRIajDmMFQGA1UdIARNMEswSQYEVR0gADBBMD8GCCsGAQUFBwIBFjNodHRwOi8v
# d3d3Lm1pY3Jvc29mdC5jb20vcGtpb3BzL0RvY3MvUmVwb3NpdG9yeS5odG0wGQYJ
# KwYBBAGCNxQCBAweCgBTAHUAYgBDAEEwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSME
# GDAWgBTIftJqhSobyhmYBAcnz1AQT2ioojCBhAYDVR0fBH0wezB5oHegdYZzaHR0
# cDovL3d3dy5taWNyb3NvZnQuY29tL3BraW9wcy9jcmwvTWljcm9zb2Z0JTIwSWRl
# bnRpdHklMjBWZXJpZmljYXRpb24lMjBSb290JTIwQ2VydGlmaWNhdGUlMjBBdXRo
# b3JpdHklMjAyMDIwLmNybDCBwwYIKwYBBQUHAQEEgbYwgbMwgYEGCCsGAQUFBzAC
# hnVodHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NlcnRzL01pY3Jvc29m
# dCUyMElkZW50aXR5JTIwVmVyaWZpY2F0aW9uJTIwUm9vdCUyMENlcnRpZmljYXRl
# JTIwQXV0aG9yaXR5JTIwMjAyMC5jcnQwLQYIKwYBBQUHMAGGIWh0dHA6Ly9vbmVv
# Y3NwLm1pY3Jvc29mdC5jb20vb2NzcDANBgkqhkiG9w0BAQwFAAOCAgEAfyUqnv7U
# q+rdZgrbVyNMul5skONbhls5fccPlmIbzi+OwVdPQ4H55v7VOInnmezQEeW4LqK0
# wja+fBznANbXLB0KrdMCbHQpbLvG6UA/Xv2pfpVIE1CRFfNF4XKO8XYEa3oW8oVH
# +KZHgIQRIwAbyFKQ9iyj4aOWeAzwk+f9E5StNp5T8FG7/VEURIVWArbAzPt9ThVN
# 3w1fAZkF7+YU9kbq1bCR2YD+MtunSQ1Rft6XG7b4e0ejRA7mB2IoX5hNh3UEauY0
# byxNRG+fT2MCEhQl9g2i2fs6VOG19CNep7SquKaBjhWmirYyANb0RJSLWjinMLXN
# OAga10n8i9jqeprzSMU5ODmrMCJE12xS/NWShg/tuLjAsKP6SzYZ+1Ry358ZTFcx
# 0FS/mx2vSoU8s8HRvy+rnXqyUJ9HBqS0DErVLjQwK8VtsBdekBmdTbQVoCgPCqr+
# PDPB3xajYnzevs7eidBsM71PINK2BoE2UfMwxCCX3mccFgx6UsQeRSdVVVNSyALQ
# e6PT12418xon2iDGE81OGCreLzDcMAZnrUAx4XQLUz6ZTl65yPUiOh3k7Yww94lD
# f+8oG2oZmDh5O1Qe38E+M3vhKwmzIeoB1dVLlz4i3IpaDcR+iuGjH2TdaC1ZOmBX
# iCRKJLj4DT2uhJ04ji+tHD6n58vhavFIrmcxghqRMIIajQIBATBxMFoxCzAJBgNV
# BAYTAlVTMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xKzApBgNVBAMT
# Ik1pY3Jvc29mdCBJRCBWZXJpZmllZCBDUyBBT0MgQ0EgMDICEzMABhp5Mx317l5t
# qaIAAAAGGnkwDQYJYIZIAWUDBAIBBQCgXjAQBgorBgEEAYI3AgEMMQIwADAZBgkq
# hkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAvBgkqhkiG9w0BCQQxIgQg1nFXwePD4trI
# 8K6nysc8Wzc2hYUQ9/ym/2ZfZymcu0kwDQYJKoZIhvcNAQEBBQAEggGAOiDkQbXs
# C6jqpVutZsM18wTVhgxHVwvbU3jkYUJbSNdFeTzPea3Cx1S+mCEtBCF8x6pdQHbq
# 5OY9JlVsEC2ghf5oiW+QpOi0ivDcdHr43xxvG8E9MqEo6Pom973gC2QGRjhc7rPr
# EOsbgKcY/IxZ4OZFbRpx5CsV8lP4kyOzn/vs7DNkWoXbhj1AroZKn2hYkHKzdWz0
# h3uOvsBNJtKvHKFpRdZ6xUqjzAgqjySGtWj4INk3IAXzUx/jpiId0GZKmrQNd0qB
# 7M5r/3D0pMRQTKOGZ8VaOp34V3DfZ4UFcoH8yp5uoHx/oH4KRTlAL2/TrhpY91Ts
# kxDgz6HGKHlhoa+pgjY7zrOqvHop6eJ2ffxVkZkwFt/2/U3EA3msLWCbZL/RXKS/
# GSkOkQL+5gOmbl//XYs1POidFj+UXBa592MOjdD/y8zNynHqslve/Zy/HYHB6qCV
# fkPlRWjKIF9CXw2e1svAWw5pzHsQPEpjOStTCidCADl8JkGOhSdTy3D6oYIYETCC
# GA0GCisGAQQBgjcDAwExghf9MIIX+QYJKoZIhvcNAQcCoIIX6jCCF+YCAQMxDzAN
# BglghkgBZQMEAgEFADCCAWIGCyqGSIb3DQEJEAEEoIIBUQSCAU0wggFJAgEBBgor
# BgEEAYRZCgMBMDEwDQYJYIZIAWUDBAIBBQAEIJ7EXMkmwYS7kiwEkjRiX1y5MBj+
# D5rvIPmrB2qW4UrDAgZpBcj2L10YEzIwMjUxMTEyMTAzMjExLjk5M1owBIACAfSg
# geGkgd4wgdsxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYD
# VQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xJTAj
# BgNVBAsTHE1pY3Jvc29mdCBBbWVyaWNhIE9wZXJhdGlvbnMxJzAlBgNVBAsTHm5T
# aGllbGQgVFNTIEVTTjo3ODAwLTA1RTAtRDk0NzE1MDMGA1UEAxMsTWljcm9zb2Z0
# IFB1YmxpYyBSU0EgVGltZSBTdGFtcGluZyBBdXRob3JpdHmggg8hMIIHgjCCBWqg
# AwIBAgITMwAAAAXlzw//Zi7JhwAAAAAABTANBgkqhkiG9w0BAQwFADB3MQswCQYD
# VQQGEwJVUzEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMUgwRgYDVQQD
# Ez9NaWNyb3NvZnQgSWRlbnRpdHkgVmVyaWZpY2F0aW9uIFJvb3QgQ2VydGlmaWNh
# dGUgQXV0aG9yaXR5IDIwMjAwHhcNMjAxMTE5MjAzMjMxWhcNMzUxMTE5MjA0MjMx
# WjBhMQswCQYDVQQGEwJVUzEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9u
# MTIwMAYDVQQDEylNaWNyb3NvZnQgUHVibGljIFJTQSBUaW1lc3RhbXBpbmcgQ0Eg
# MjAyMDCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAJ5851Jj/eDFnwV9
# Y7UGIqMcHtfnlzPREwW9ZUZHd5HBXXBvf7KrQ5cMSqFSHGqg2/qJhYqOQxwuEQXG
# 8kB41wsDJP5d0zmLYKAY8Zxv3lYkuLDsfMuIEqvGYOPURAH+Ybl4SJEESnt0MbPE
# oKdNihwM5xGv0rGofJ1qOYSTNcc55EbBT7uq3wx3mXhtVmtcCEr5ZKTkKKE1CxZv
# NPWdGWJUPC6e4uRfWHIhZcgCsJ+sozf5EeH5KrlFnxpjKKTavwfFP6XaGZGWUG8T
# ZaiTogRoAlqcevbiqioUz1Yt4FRK53P6ovnUfANjIgM9JDdJ4e0qiDRm5sOTiEQt
# BLGd9Vhd1MadxoGcHrRCsS5rO9yhv2fjJHrmlQ0EIXmp4DhDBieKUGR+eZ4CNE3c
# tW4uvSDQVeSp9h1SaPV8UWEfyTxgGjOsRpeexIveR1MPTVf7gt8hY64XNPO6iyUG
# sEgt8c2PxF87E+CO7A28TpjNq5eLiiunhKbq0XbjkNoU5JhtYUrlmAbpxRjb9tSr
# eDdtACpm3rkpxp7AQndnI0Shu/fk1/rE3oWsDqMX3jjv40e8KN5YsJBnczyWB4Jy
# eeFMW3JBfdeAKhzohFe8U5w9WuvcP1E8cIxLoKSDzCCBOu0hWdjzKNu8Y5SwB1lt
# 5dQhABYyzR3dxEO/T1K/BVF3rV69AgMBAAGjggIbMIICFzAOBgNVHQ8BAf8EBAMC
# AYYwEAYJKwYBBAGCNxUBBAMCAQAwHQYDVR0OBBYEFGtpKDo1L0hjQM972K9J6T7Z
# PdshMFQGA1UdIARNMEswSQYEVR0gADBBMD8GCCsGAQUFBwIBFjNodHRwOi8vd3d3
# Lm1pY3Jvc29mdC5jb20vcGtpb3BzL0RvY3MvUmVwb3NpdG9yeS5odG0wEwYDVR0l
# BAwwCgYIKwYBBQUHAwgwGQYJKwYBBAGCNxQCBAweCgBTAHUAYgBDAEEwDwYDVR0T
# AQH/BAUwAwEB/zAfBgNVHSMEGDAWgBTIftJqhSobyhmYBAcnz1AQT2ioojCBhAYD
# VR0fBH0wezB5oHegdYZzaHR0cDovL3d3dy5taWNyb3NvZnQuY29tL3BraW9wcy9j
# cmwvTWljcm9zb2Z0JTIwSWRlbnRpdHklMjBWZXJpZmljYXRpb24lMjBSb290JTIw
# Q2VydGlmaWNhdGUlMjBBdXRob3JpdHklMjAyMDIwLmNybDCBlAYIKwYBBQUHAQEE
# gYcwgYQwgYEGCCsGAQUFBzAChnVodHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtp
# b3BzL2NlcnRzL01pY3Jvc29mdCUyMElkZW50aXR5JTIwVmVyaWZpY2F0aW9uJTIw
# Um9vdCUyMENlcnRpZmljYXRlJTIwQXV0aG9yaXR5JTIwMjAyMC5jcnQwDQYJKoZI
# hvcNAQEMBQADggIBAF+Idsd+bbVaFXXnTHho+k7h2ESZJRWluLE0Oa/pO+4ge/XE
# izXvhs0Y7+KVYyb4nHlugBesnFqBGEdC2IWmtKMyS1OWIviwpnK3aL5JedwzbeBF
# 7POyg6IGG/XhhJ3UqWeWTO+Czb1c2NP5zyEh89F72u9UIw+IfvM9lzDmc2O2END7
# MPnrcjWdQnrLn1Ntday7JSyrDvBdmgbNnCKNZPmhzoa8PccOiQljjTW6GePe5sGF
# uRHzdFt8y+bN2neF7Zu8hTO1I64XNGqst8S+w+RUdie8fXC1jKu3m9KGIqF4aldr
# YBamyh3g4nJPj/LR2CBaLyD+2BuGZCVmoNR/dSpRCxlot0i79dKOChmoONqbMI8m
# 04uLaEHAv4qwKHQ1vBzbV/nG89LDKbRSSvijmwJwxRxLLpMQ/u4xXxFfR4f/gksS
# kbJp7oqLwliDm/h+w0aJ/U5ccnYhYb7vPKNMN+SZDWycU5ODIRfyoGl59BsXR/Hp
# RGtiJquOYGmvA/pk5vC1lcnbeMrcWD/26ozePQ/TWfNXKBOmkFpvPE8CH+EeGGWz
# qTCjdAsno2jzTeNSxlx3glDGJgcdz5D/AAxw9Sdgq/+rY7jjgs7X6fqPTXPmaCAJ
# KVHAP19oEjJIBwD1LyHbaEgBxFCogYSOiUIr0Xqcr1nJfiWG2GwYe6ZoAF1bMIIH
# lzCCBX+gAwIBAgITMwAAAFck05XgounJMQAAAAAAVzANBgkqhkiG9w0BAQwFADBh
# MQswCQYDVQQGEwJVUzEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMTIw
# MAYDVQQDEylNaWNyb3NvZnQgUHVibGljIFJTQSBUaW1lc3RhbXBpbmcgQ0EgMjAy
# MDAeFw0yNTEwMjMyMDQ2NTNaFw0yNjEwMjIyMDQ2NTNaMIHbMQswCQYDVQQGEwJV
# UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UE
# ChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSUwIwYDVQQLExxNaWNyb3NvZnQgQW1l
# cmljYSBPcGVyYXRpb25zMScwJQYDVQQLEx5uU2hpZWxkIFRTUyBFU046NzgwMC0w
# NUUwLUQ5NDcxNTAzBgNVBAMTLE1pY3Jvc29mdCBQdWJsaWMgUlNBIFRpbWUgU3Rh
# bXBpbmcgQXV0aG9yaXR5MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA
# sWylCpMIfbizJLY1kPXO2cmX2HRWvRbAmeKSZ5ex7/jCymdV7Eap+Ic2iqRtWDkK
# Ke5gL6JV80wtn5C2qHJLPxUYFKNG3UkHkAI21MoCN+YWnhT8K/YuPib6+6970jdb
# eFKIiZMWwd5hnpX9J3jeteuEdXbp/DfFBK15JuD3JOzWuF2suQCPgqYjQPk/gpq+
# 3KCKtXJRbXSCSJ9YtITU2IHwmfdE7l2PfZ154w041po+fDeTj0gJOzcV/Jv56Q0M
# +w19jAKo/I5PEzrLV1IPQnmP4or1X4RbJXk8ONXyOOfXOxK2VLpNxgklK1yAezbF
# P2uzqihaXkW1h9GQLGENKESnezwgdRaLNNaYtm8AT/pZHYJ35mZVqkZdMIckpQHJ
# k/F1fSLyDKeKtH4TC4cc3ESKUMgItq07ZZm74JCsfhmrQ1ijVNDi1Sln+QBamgC7
# WviZbkQnceQRq9DY+6hANwOrasAZUiVr2kPuj1jHDOXzUG4O9QTK70P/oXSqZAN1
# oTv3UfF8JTGmAxg+l1ZPOz50MY96HBDw/3bI/wBGNvLk6fLVnrxGN5B5unF/lYvj
# jWbIUdyBPVQnPOKXu08SRHbY19M1HoWX6PNZv+vzSeqVeWWHKdKjC3GjVjbbGpi+
# JLbiyaKRSwEqo49tJLvu69cQ7dWsbksai4TURnVj2mMCAwEAAaOCAcswggHHMB0G
# A1UdDgQWBBSOg8leLTUOAglIZ+bjXpiD7RKSpzAfBgNVHSMEGDAWgBRraSg6NS9I
# Y0DPe9ivSek+2T3bITBsBgNVHR8EZTBjMGGgX6BdhltodHRwOi8vd3d3Lm1pY3Jv
# c29mdC5jb20vcGtpb3BzL2NybC9NaWNyb3NvZnQlMjBQdWJsaWMlMjBSU0ElMjBU
# aW1lc3RhbXBpbmclMjBDQSUyMDIwMjAuY3JsMHkGCCsGAQUFBwEBBG0wazBpBggr
# BgEFBQcwAoZdaHR0cDovL3d3dy5taWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9N
# aWNyb3NvZnQlMjBQdWJsaWMlMjBSU0ElMjBUaW1lc3RhbXBpbmclMjBDQSUyMDIw
# MjAuY3J0MAwGA1UdEwEB/wQCMAAwFgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYD
# VR0PAQH/BAQDAgeAMGYGA1UdIARfMF0wUQYMKwYBBAGCN0yDfQEBMEEwPwYIKwYB
# BQUHAgEWM2h0dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9wa2lvcHMvRG9jcy9SZXBv
# c2l0b3J5Lmh0bTAIBgZngQwBBAIwDQYJKoZIhvcNAQEMBQADggIBAHJ1wHY86Zk5
# SUBDPY25d/u9YJVaaNa71uxjX4cyO/XJ4uPENCSOwkRTnNogPLxTD0Fg3z4TFf/2
# T/0IFSxdtWVtTjhzrn+WLInzeRawUhTCFVrPBJKEWVshm+Ig7/nB7JbJN88+ltIm
# BbL5kT1StBLfG6UksAcDbNSQww90CUXhGueBxlnSvjkAX1ohiN16y1bB2s0rvQx8
# Csepl2CuBefTfDrMGzW/tzNx5YaK2D8OWweqTWZcGlJO4YjZNI83cTrQghfHl/8A
# XOHj8cWL3wEFltQQs2xeRYAb3Kdnl7oIWKKXWaBYJY5P3QPsiC+DTMp7ejdYKTrb
# 396f3gr+wL/Ms5/Z3vIWZPJJv18qNw40fUNveRnwzMQnx8dM2bGuXXQZ5y7P8aXT
# 4HJMo349qZtn4XQwiUE/DDp++MUL0kgjvd/Deo7Xr371PFPPYb4TboZhjV1x9+wC
# HDoOpNCBt+VuXU78ytJdKzQ1Jv2cEP1F9H9/wSLsMDUvWME7u9mGElOPDZPMVr8A
# uBEuLdbTSEdaLwsZBplzxLBcgxhZ/Cs30yBhuE3QhqT1YDZ2pa56RexPA2SasPcT
# oT6gJgJ6E06BmZ2zQTNvWOjs5XQqHbYuXcoeDcwe2UaC7EDOGD8GmLE9LiqtQsuQ
# CM7v7I2xR+sPZT2Ax/85HjIkM+3MzTK1MYIHQzCCBz8CAQEweDBhMQswCQYDVQQG
# EwJVUzEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMTIwMAYDVQQDEylN
# aWNyb3NvZnQgUHVibGljIFJTQSBUaW1lc3RhbXBpbmcgQ0EgMjAyMAITMwAAAFck
# 05XgounJMQAAAAAAVzANBglghkgBZQMEAgEFAKCCBJwwEQYLKoZIhvcNAQkQAg8x
# AgUAMBoGCSqGSIb3DQEJAzENBgsqhkiG9w0BCRABBDAcBgkqhkiG9w0BCQUxDxcN
# MjUxMTEyMTAzMjExWjAvBgkqhkiG9w0BCQQxIgQgGIVj2gv/ID+zhmfR+r3Ey9DA
# 1QCdJG0tF6Lfd6bZNccwgbkGCyqGSIb3DQEJEAIvMYGpMIGmMIGjMIGgBCD1PJ9k
# tQVuTGWIbKLO4f1VUOlUU29ARCEpDZmFTHjbUjB8MGWkYzBhMQswCQYDVQQGEwJV
# UzEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMTIwMAYDVQQDEylNaWNy
# b3NvZnQgUHVibGljIFJTQSBUaW1lc3RhbXBpbmcgQ0EgMjAyMAITMwAAAFck05Xg
# ounJMQAAAAAAVzCCA14GCyqGSIb3DQEJEAISMYIDTTCCA0mhggNFMIIDQTCCAikC
# AQEwggEJoYHhpIHeMIHbMQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3Rv
# bjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
# aW9uMSUwIwYDVQQLExxNaWNyb3NvZnQgQW1lcmljYSBPcGVyYXRpb25zMScwJQYD
# VQQLEx5uU2hpZWxkIFRTUyBFU046NzgwMC0wNUUwLUQ5NDcxNTAzBgNVBAMTLE1p
# Y3Jvc29mdCBQdWJsaWMgUlNBIFRpbWUgU3RhbXBpbmcgQXV0aG9yaXR5oiMKAQEw
# BwYFKw4DAhoDFQD9LzE5nEJRAUE2Ss3xaKKPXHnLw6BnMGWkYzBhMQswCQYDVQQG
# EwJVUzEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMTIwMAYDVQQDEylN
# aWNyb3NvZnQgUHVibGljIFJTQSBUaW1lc3RhbXBpbmcgQ0EgMjAyMDANBgkqhkiG
# 9w0BAQsFAAIFAOy+x+cwIhgPMjAyNTExMTIwODQ2MzFaGA8yMDI1MTExMzA4NDYz
# MVowdDA6BgorBgEEAYRZCgQBMSwwKjAKAgUA7L7H5wIBADAHAgEAAgIkZDAHAgEA
# AgIShTAKAgUA7MAZZwIBADA2BgorBgEEAYRZCgQCMSgwJjAMBgorBgEEAYRZCgMC
# oAowCAIBAAIDB6EgoQowCAIBAAIDAYagMA0GCSqGSIb3DQEBCwUAA4IBAQBJqtLD
# hxFIFq877p+o44mnPdRaoCPeWPTMaDVf2hRoqV6hqLvuI+OCsoqx5G9LUlLycSo4
# YdALThhWzUwNvQRQ39FQq5zosFF2zKRF7Ebre78Ott2uu7/ak/6b+d8nJ2OkUjKV
# 9ZZFEoav08QhCNjebc1m7btZkU78rgOnhFDYAP81ngBREn1m8OBvDlVhBrIGmfUJ
# 6N+d0+qhrRO87Qic1jBAM47cJHYZ1jEjb/QRWa5bUS+btBYFkMhXimRJAI3jTAuE
# xC6i/q9ar8+ret+1HsdWUeHpsf2bGLk5zWeMe2RYExjk6EV32WA/5eGzBDKAUev2
# CIfXNQxlc/6mnF94MA0GCSqGSIb3DQEBAQUABIICAC6kGMLcUU/xeRk/ZERKZCBY
# otjrU/9qWNWTtLzOXa92ErT/9nrnoaJUSXX5z50K0sc2jYv7lZFWVSsL19JTwrmN
# faRALQAucVlAYlmKTPBiNWqbjl362/SOsGgKVfp+gIwsyXjCTfRREoFlmtqVwuzO
# yjQ2DM+88v6+oKf+LdVQ6EKNw9LmSeuNeZPXjDT6AyyfaRqzz5XvjzyuBvcVA63x
# 0RChglCDnqW5kxk33CefACiAe8D3EPYyLA2YNSzxoIQD7xOgFEB9cEFwhSl82dJA
# oebZGKrOrfnHdW7zznrgmngRNYZjJ20BWLezOjyzZZFmdstxn1tcdXtMZfCHk3t3
# +FkymWFvlfk2kgtjc8M3/xkk9Cy2wHJwKcuQQRqQyLUfN1M9Fn+toa776sJAryXU
# nGlns9n7jl71ZzvBxEaHumWTu/g3EqRbNDz0ME0fa12vjMps9wtrEoylgQ47rWBR
# wU7yiYXD4WvKLPsTPOD2R8rN9mK8ujik9TjnIfwCjcNwEeSesrJ0s2nBcemB7cHT
# GRvCqO3UFMFFZLXYK7EXO41vuMRdUODAExA5L/8iQnIMfnK/O3Vy+w50ZwYzxMZT
# JKl0orosW7mbeeNxIivQjcfJmpDKiumNydWzt497PUaIrUD/M1OAZC/X5L15/tnQ
# eMH8HWbDWNYfhrTU3oYx
# SIG # End signature block
