# Release Notes

## 2.63.3 (2.63.3)
-   Improved look of status indicators on person overview.
-   Added working life extensions to radioactive sources.
-   Added support for writing wearer name and EPD alarm thresholds to Task Database ID on issue.
-   Qualification types can now be specified for asset type categories.
-   Asset state flags are now one combined toggle option.
-   Fixed various inconsistencies with the Asset/Probe link.
-   Fixed auto update not working.
-   Fixed RadSight WPF upgrade timeout after two weeks.
-   Fixed bug that caused a task's thresholds to be deleted when disabling via the app.
-   Fixed dropdowns not working on touch screens.
-   Various bug fixes and performance improvements.

## 2.62.2 (2.62.2)
-	Added Classified Workers and DCS Compatibility modules.
-	Added Simulation Scenario module.
-	Improvements to the Data Grid and Simulation functionality.
-	Various localization fixes and improvements.
-	Added a warning when editing a location that has assets assigned to it.
-	Added the option to assign different half-life units to a nuclide.
-	Added the option to add units to field definitions.
-	Added ability to assign reports to the user index page.
-	Added ability to assign a photo to a user.
-   Various bug fixes and performance improvements.

## 2.60.2 (2.60.2)
-	Added support for multiple EPD readers.
-	Added Data Grid module that allows viewing telemetry data in a grid format.
-	Added Simulation module that allows generating simulated measurements to override incoming data.
-	Added endpoint logging to record incoming/outgoing data to a file and replay the recorded data.
-	Added a system to import settings when upgrading from UWP builds to WPF builds.
-	Improved error logging readability.
-	Fixed sync-related exceptions and memory leaks.
-	Fixed RadSight crashes related to log level changes, port selection, and reader disconnection.
-   Various bug fixes and performance improvements

## 2.51.3 (2.51.2)
-   Shortened exported filenames and included location/machine name in the filename.
-   Improved error message around issue/return process of EPDs when records with a matching issue count exist.
-	Added export of session data.
-	Fixed not being able to manually return an electronically issued RadFlash.
-	Fixed a crash during the manual return process.
-	Fixed the issued asset state not being applied to issued assets.
-	Fixed timeout when first loading tasks when self-hosting.
-	Fixed being unable to send diagnostic data when self-hosting.
-	Can no longer set terminals to transfer mode from the server settings page.
-	Fixed crash when selecting the sensor popup on the team/proximity page.
-	Fixed measurement info not being displayed correctly in exported CSV files.
-	Improved reliability of RadFlash/BleuIO.
-	Fixed missing dlls in the UWP app. 

## 2.50.8 (2.50.8)
-   Improved WPF installer
-   Added ability to start proximity session from the status bar.
-   Added support for EPD N2, and TruDose NG devices
-   Support up-to 4 display measurments on the Teams and Proximity pages.
-   Support RadEye SX
-   Various bug fixes and performance improvements

## 2.44.9 (2.44.9)
-   Fixed High CPU usage when running a vulnerability scanner.
-	Fixed an issue with whitespace on the end of User IDs.
-	Improved reliability of issue/return process.

## 2.44.6 (2.44.6)
-   Cleaned up excessive error logging and events.
-	Fixed memory leak when viewing Sync History page.

## 2.44.3 (2.44.3)
-   Connection are now closed when a sync occurrence finishes.
-   Enabled self-host and offline sync in kiosk mode. (WPF)
-   Added auto updater support. (WPF)
-   Web socket connections are now closed elegantly when verifying if web sockets are available.
-   Fixed issue with web sockets over SSL and non-SSL connections.
-   Fixed sync failure when there is a mismatch of RemoteDNA versions.
-   Fixed memory leak when viewing Sync History page.
-   Removed incorrect "RWP" localization.

## 2.43.0 (2.43.0)
-	SignalR now uses web sockets when available.
-	Fixed bugged where issue/return process would be stuck in a loop (which persistently showed orange dots).
-	Fixed crash when EPD is removed whilst loading users or activities from the server.

## 2.42.8 (2.42.8)
-	Improved French/German localisation
-	Manual Issue/Return improvements
-	Add support for Actisys PL2303GC IR Reader
-	Allow changing password for local users when in SSO mode
-	Offline sync improvements
-	Allows cancellation of initial sync
-	RadFlash communication improvements
-	Show current date/time in status bar when in kiosk mode
-	Accumulated Dose Session when in Proximity mode

## 2.42.4 (2.42.4)
-   Keypad improvements in issue/return process
-   Improved French localisation
-   Fix Task List report not showing Hp07 correctly
-   Fix reports timezone issue on Windows Server 2019
-   Show Dose Adjustment in menu in Issue/Return
-   Allow Admin role to Import data
-   Fix LTS radios on UWP platform
-   Other performance and usability fixes
-   Improve TruDose MK3.1 communication reliability

## 2.41.1 (2.41.1)
-   RadFlash performance and reliability improvements
-   Support for ARM1000, RPC-1000, AMS-4 in RadSight app

## 2.40 (2.40)
-	Manual Issue/Return feature in mainstream build
-	Performance improvements and bug fixes
-   Added in-app admin support
-   Added offline sync connection mode

## 2.30 (2.30)
-	Manual Issue/Return feature

## 2.25.0 (2.25.0)
-	No longer shows unlicensed sensors on the diagnostics page
-   Added support for checking in an EPD

## 2.24.1 (2.24.5)
-	Added new configured mode in RadSight app to clear dose on RadFlash
-   Added missing localisation
-   Added timeout to RadFlash issue process and refined Bluetooth calibration
-   Added support for serial/com ports in endpoints
-   Added support for RPC-1000/AMS-4 Binary
-	Dashboard can now show more than 8 devices using mini widgets
-	Add zone filter to map
-	Fix RemoteDNA memory leak
-	Fix event block on one user showing on all users 
-	Fix problem where EPD is left in reader when server restarts
-	Improved RadFlash proximity detection
-   Export from app fixed to use local time for file name and data
-   Make serial endpoints release com port when disabled or deleted

## 2.23.5 (2.23.5)
-   More performance improvements with large datasets
-	Fix memory leak causing RemoteDNA service to use up server memory
-	Add exact matching option for selecting user and task to speed up issue and return
-	Prevent issue when calibration in database has expired
-	Set more conservative default alarm thresholds for new tasks
-	Change reports to server side queries and remove 1 year limit
-	Add setting for DOB required on users
-	Correct RadEye B20 counts
-	Add alarm levels to issue screen
-	Add customised text for browser message in AUS locale
-	Prevent creating users with same name and DOB
-	Fix issue when no message is shown when auto-adding sensors is disabled

## 2.22.0 (2.22.0)
-   Improve performance with large datasets
-   Fix SSO issues

## 2.21.2 (2.21.4)
-   Fixed LTS radios not being detected (UWP)

## 2.21.1 (2.21.4)
-   Add support for the BleuIO dongle (WPF)
-   Fix issue setting Team row colour from proximity page
-   Fix issue where alarm sound would not stop on Windows (WPF)
-   Fix issue where CNET GPS would not work in certain locales
-   Remove chart from Dashboard
-	Various minor bug fixes

## 2.20.3 (RemoteDNA 2.20.5.6122)
A major update to add RadSight Enterprise functionality for access control and use in large nuclear sites 
-   Additional dose constraint periods (daily, quarterly, monthly)
-   Enhanced filtering for index pages (users, tasks, etc.)
-   Activity dose limits, limit total dose received on a task
-   Access control requirements (training, medical, authorization, etc.)
-   Issue prompts can be configured
-   Configurable messages for all messages used in issue/return
-   PDF view in issue process, used for viewing task/RWP document
-   Enhanced API for data import including database interface for adding and updating data using an import service
-   Addition of companies and departments as person data
-   Enhancements to offline mode and database sync
-   Manual dose adjustments and dose amendments
-   Configure person ID and task ID to be unique
-   Azure AD integration
-   Issue and return events
-   Event notification services can now be configured (Twilio, SMTP, etc.)

## 2.0.3 (RemoteDNA 2.18.6.5662)
-   Sync bug fixes
-	Fixes issue with data import

## 2.0.2 (RemoteDNA 2.18.4.5623)
-   Improve offline mode
-	Enterprise reporting including in app report designer
-	Unique user IDs and task IDs (optional)
-	Various bug fixes

## 2.0.1 (RemoteDNA 2.18.1.5376)
-   Added offline mode and data synchronization
-   Added security features and user roles
-   Added import API
-	Issue record amendments and audit tracking
-   Now reads EPD to determine issue state

## 1.6.0 (RemoteDNA 2.16.30.4888)
-   Added RSSI telemetry filtering using BLE signal strength
-   Added built-in display brightness control
-   Added Task limits
-   Added RadFlash Bluetooth Issue/Return support including BLE range calibration wizard
-   Added ability to configure terminal as Issue Only, Return only, or Auto (default)
-   Improved timeout picker on team/proximity row popup
-   Dose limits now includes Quarterly, Monthly, and Daily limits
-   Naming change: 'Activities' are now 'Tasks' in (EN)
-   Enterprise: The Issue/Return Wizard text can now be customised (Custom Display Text)
-   Various bug fixes and performance improvements

## 1.5.6 (RemoteDNA 2.15.8.4093)
-   Added team/proximity row popup to show additional info
-   Now shows thresholds when selecting an activity
-   Changed telemetry icon
-   Bluetooth telemetry continues to work when under load

## 1.5.5 (RemoteDNA 2.14.5.3804)
-   Added screenshot feature
-   Added proximity page
-   Correct units now shown when dose limit has been exceeded
-   Improved in-app diagnostics
-   Export page now requires user to enter supervisor PIN if one is configured

## 1.5.4 (RemoteDNA 2.13.5.3541)
-   Additional support for SQL Server database
-   Manual Issue enhancements to allow addition of dose records for initial dose or dose adjustments
-   TruDose-NG dose profile 
-   Default dose limit applied to new users as they are created
-   In app software upgrade process for RadSight application
-   Various bug fixes and performance improvements

## 1.5.3 (RemoteDNA 2.11.11.3209)
-   Annual dose limits
-   TruDose NG support
-   EPD Beep on Issue/Return option
-   Enterprise: Support custom SSL certificate selection
-   RadSight Id: Support for TLDs
-   Italian localisation
-   Various bug fixes and performance improvements

## 1.5.2 (RemoteDNA 2.10.11.2724)
-   Make SelfHosted selector visible in Settings for all UWP installations and make Reset procedure more consistent and reliable
-   Change ARM-1000 sensor type name to upper case i.e. ARM1000
-   Add folder so that UWP downloads come in a Win10 folder by default

## 1.5.1 (RemoteDNA 2.10.10.2703)
-   Changes to support new browser security requirements to fix Chrome and Edge login issues
-   Beta support for ARM-1000 and RadEye PX instruments
-   Show warnings if EPD telemetry can't be enabled
-   Fix initialisation issues when using UWP version and on terminals
-   Show primary measurement name on Team screen
-   Fix problem where RadEye does not appear as a sensor type
-   Show user name on Return screen

## 1.5.0 (RemoteDNA 2.10.6.2625)
-   Allow primary and secondary measurements to be selected
-   Control ability to add Activity/User/Sensor from client
-   Allow timeout of team row after period of inactivity
-   Supervisor PIN for settings access
-   Centrally manage client settings (disabled by default on new installations)
-   Audible alarm support (enabled by default)
-   Allow display units to be configurable within the application

## 1.4.2 (RemoteDNA 2.9.15.2432)
-   RemoteDNA server data is now shown on Team screen in RadSight app
-   Additional support for DNT24 radios using protocol mode
-   Fix problem with replacing an EPD using the disable feature
-   Fix problem disabling user logins
-   Improvements to EPD read after a period of inactivity

## 1.4.1 (RemoteDNA 2.9.12.2330)
-   Minor fix for Issue/Return data being interpreted incorrectly when self-hosted
-   Ability to reset administrator account
-   French translation improvements

## 1.4.0 (RemoteDNA 2.9.11.2325)
-   Improved compatibility with EasyEPD
-   Transfer Terminal feature, to allow RadSight to integrate with other dosimetry systems
-   Real-time trend graph on Team screen showing short dose rate history
-   Dose export from app when USB key inserted
-   Dose profile download from EPD and improved graphing facility
